/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.recipes;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.imbuement.CharmChargingRecipe;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;

public class CharmChargingProvider
extends SimpleDataProvider {
    public List<CharmChargingRecipe> recipes = new ArrayList<CharmChargingRecipe>();

    public CharmChargingProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (CharmChargingRecipe recipe : this.recipes) {
            Path path = CharmChargingProvider.getRecipePath(this.output, recipe.id().getPath());
            CharmChargingRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).result().ifPresent(json -> this.saveStable(pOutput, (JsonElement)json, path));
        }
    }

    protected void addEntries() {
        for (Map.Entry<CharmRegistry.CharmType, ItemRegistryWrapper<Item>> entry : AddonItemRegistry.CHARMS.entrySet()) {
            CharmRegistry.CharmType type = entry.getKey();
            this.addEntry(type.getSerializedName(), (Item)entry.getValue().get(), type.getCostPerCharge());
        }
    }

    private void addEntry(String id, Item reagent, int costPerCharge) {
        this.recipes.add(new CharmChargingRecipe(ArsAdditions.prefix(id), reagent, costPerCharge));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_additions/recipe/imbuement_charging/" + id + ".json");
    }

    public String getName() {
        return "Imbuement Charging Datagen";
    }
}

